/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlaceGhostRecipe;
import net.minecraft.util.ServerRecipeBookHelper;
import net.minecraftforge.common.crafting.IRecipeContainer;
import net.minecraftforge.common.crafting.IShapedRecipe;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.client.util.NPCRecipeItemHelper;
import noppes.npcs.controllers.data.Availability;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerRecipeBookHelper.class}, remap=false, priority=499)
public class ServerRecipeBookHelperMixin {
    @Final
    @Shadow(aliases={"field_194331_b"})
    private RecipeItemHelper recipeItemHelper = new NPCRecipeItemHelper();
    @Shadow(aliases={"field_194332_c"})
    private EntityPlayerMP player;
    @Shadow(aliases={"field_194333_d"})
    private IRecipe recipe;
    @Shadow(aliases={"field_194334_e"})
    private boolean isShiftPressed;
    @Shadow(aliases={"field_194335_f"})
    private InventoryCraftResult invCraftResult;
    @Shadow(aliases={"field_194336_g"})
    private InventoryCrafting invCrafting;
    @Shadow(aliases={"field_194337_h"})
    private List<Slot> slots;
    @Unique
    private boolean npcs$ignoreDamage = false;
    @Unique
    private boolean npcs$ignoreNBT = false;

    @Inject(method={"func_194327_a"}, at={@At(value="HEAD")}, cancellable=true)
    public void npcs$processCraftRecipe(EntityPlayerMP playerMP, @Nullable IRecipe iRecipe, boolean shiftPressed, CallbackInfo ci) {
        ci.cancel();
        if (iRecipe == null || !playerMP.func_192037_E().func_193830_f(iRecipe)) {
            return;
        }
        this.player = playerMP;
        this.recipe = iRecipe;
        this.isShiftPressed = shiftPressed;
        this.slots = playerMP.field_71070_bA.field_75151_b;
        Container container = playerMP.field_71070_bA;
        this.invCraftResult = null;
        this.invCrafting = null;
        if (container instanceof ContainerWorkbench) {
            this.invCraftResult = ((ContainerWorkbench)container).field_75160_f;
            this.invCrafting = ((ContainerWorkbench)container).field_75162_e;
        } else if (container instanceof ContainerPlayer) {
            this.invCraftResult = ((ContainerPlayer)container).field_75179_f;
            this.invCrafting = ((ContainerPlayer)container).field_75181_e;
        } else if (container instanceof IRecipeContainer) {
            this.invCraftResult = ((IRecipeContainer)container).getCraftResult();
            this.invCrafting = ((IRecipeContainer)container).getCraftMatrix();
        }
        boolean isAvailability = true;
        if (this.recipe instanceof INpcRecipe) {
            this.npcs$ignoreDamage = ((INpcRecipe)this.recipe).getIgnoreDamage();
            this.npcs$ignoreNBT = ((INpcRecipe)this.recipe).getIgnoreNBT();
            Availability availability = (Availability)((INpcRecipe)this.recipe).getAvailability();
            isAvailability = availability.isAvailable((EntityPlayer)this.player);
        }
        if (this.invCraftResult == null && this.invCrafting == null || !this.npcs$canPlaceStacks() && !playerMP.func_184812_l_()) {
            return;
        }
        this.recipeItemHelper.func_194119_a();
        playerMP.field_71071_by.func_194016_a(this.recipeItemHelper, false);
        this.invCrafting.func_194018_a(this.recipeItemHelper);
        if (isAvailability && this.recipeItemHelper.func_194116_a(iRecipe, null)) {
            this.npcs$placeRecipeInCraftingGrid();
        } else {
            this.npcs$clearInventoryCrafting();
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketPlaceGhostRecipe(playerMP.field_71070_bA.field_75152_c, iRecipe));
        }
        playerMP.field_71071_by.func_70296_d();
    }

    @Unique
    private void npcs$clearInventoryCrafting() {
        InventoryPlayer inventoryplayer = this.player.field_71071_by;
        for (int i = 0; i < this.invCrafting.func_70302_i_(); ++i) {
            ItemStack itemstack = this.invCrafting.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            while (itemstack.func_190916_E() > 0) {
                int slotID = inventoryplayer.func_70432_d(itemstack);
                if (slotID == -1) {
                    slotID = inventoryplayer.func_70447_i();
                }
                ItemStack itemstack1 = itemstack.func_77946_l();
                itemstack1.func_190920_e(1);
                inventoryplayer.func_191971_c(slotID, itemstack1);
                this.invCrafting.func_70298_a(i, 1);
            }
        }
        this.invCrafting.func_174888_l();
        this.invCraftResult.func_174888_l();
    }

    @Unique
    public void npcs$placeRecipeInCraftingGrid() {
        int minCraftableStacks;
        IntArrayList listOfItemIDs;
        boolean isMatches = this.recipe.func_77569_a(this.invCrafting, this.player.field_70170_p);
        int maxCraftableStacks = this.recipeItemHelper.func_194121_a(this.recipe, this.invCrafting.func_70297_j_(), null);
        if (isMatches) {
            boolean flag = true;
            for (int i = 0; i < this.invCrafting.func_70302_i_(); ++i) {
                ItemStack itemstack = this.invCrafting.func_70301_a(i);
                if (itemstack.func_190926_b() || Math.min(maxCraftableStacks, itemstack.func_77976_d()) <= itemstack.func_190916_E()) continue;
                flag = false;
            }
            if (flag) {
                return;
            }
        }
        if (!this.recipeItemHelper.func_194118_a(this.recipe, (IntList)(listOfItemIDs = new IntArrayList()), minCraftableStacks = this.npcs$getSmallestCraftableStack(maxCraftableStacks, isMatches))) {
            return;
        }
        int craftableCount = minCraftableStacks;
        IntListIterator intListIterator = listOfItemIDs.iterator();
        while (intListIterator.hasNext()) {
            int itemID = (Integer)intListIterator.next();
            int maxStack = NPCRecipeItemHelper.unpack(itemID).func_77976_d();
            if (maxStack >= craftableCount) continue;
            craftableCount = maxStack;
        }
        if (this.recipeItemHelper.func_194118_a(this.recipe, (IntList)listOfItemIDs, craftableCount)) {
            this.npcs$clearInventoryCrafting();
            this.npcs$fillCraftingGrid(craftableCount, (IntList)listOfItemIDs);
        }
    }

    @Unique
    private int npcs$getSmallestCraftableStack(int maximum, boolean isMatches) {
        int amount = 1;
        if (this.isShiftPressed) {
            return maximum;
        }
        if (isMatches) {
            amount = 64;
            for (int i = 0; i < this.invCrafting.func_70302_i_(); ++i) {
                ItemStack itemstack = this.invCrafting.func_70301_a(i);
                if (itemstack.func_190926_b() || amount <= itemstack.func_190916_E()) continue;
                amount = itemstack.func_190916_E();
            }
            if (amount < 64) {
                ++amount;
            }
        }
        return amount;
    }

    @Unique
    private void npcs$fillCraftingGrid(int craftableCount, IntList listOfItemIDs) {
        int width = this.invCrafting.func_174922_i();
        int height = this.invCrafting.func_174923_h();
        if (this.recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedrecipes = (IShapedRecipe)this.recipe;
            width = shapedrecipes.getRecipeWidth();
            height = shapedrecipes.getRecipeHeight();
        }
        int slotID = 1;
        IntListIterator iterator = listOfItemIDs.iterator();
        for (int k = 0; k < this.invCrafting.func_174922_i() && height != k; ++k) {
            for (int l = 0; l < this.invCrafting.func_174923_h(); ++l) {
                if (width == l || !iterator.hasNext()) {
                    slotID += this.invCrafting.func_174922_i() - l;
                    break;
                }
                Slot slot = this.slots.get(slotID);
                ItemStack itemstack = NPCRecipeItemHelper.unpack((Integer)iterator.next());
                if (!itemstack.func_190926_b()) {
                    int count = 1;
                    if (this.recipe instanceof INpcRecipe) {
                        ItemStack[] ingStacks;
                        for (ItemStack st : ingStacks = ((Ingredient)this.recipe.func_192400_c().get(slotID - 1)).func_193365_a()) {
                            if (st.func_190926_b() || !NoppesUtilPlayer.compareItems(st, itemstack, this.npcs$ignoreDamage, this.npcs$ignoreNBT)) continue;
                            count = st.func_190916_E();
                            break;
                        }
                    }
                    for (int i = 0; i < craftableCount; ++i) {
                        this.npcs$decrStack(slot, itemstack, count);
                    }
                }
                ++slotID;
            }
            if (!iterator.hasNext()) break;
        }
    }

    @Unique
    private void npcs$decrStack(Slot slot, ItemStack stack, int count) {
        InventoryPlayer inventoryplayer = this.player.field_71071_by;
        while (count > 0) {
            int slotID = inventoryplayer.func_194014_c(stack);
            if (slotID == -1) {
                return;
            }
            ItemStack itemstack = inventoryplayer.func_70301_a(slotID).func_77946_l();
            if (itemstack.func_190926_b()) {
                return;
            }
            if (itemstack.func_190916_E() > 1) {
                inventoryplayer.func_70298_a(slotID, 1);
            } else {
                inventoryplayer.func_70304_b(slotID);
            }
            if (slot.func_75211_c().func_190926_b()) {
                itemstack.func_190920_e(1);
                slot.func_75215_d(itemstack);
            } else {
                slot.func_75211_c().func_190917_f(1);
            }
            --count;
        }
    }

    @Unique
    private boolean npcs$canPlaceStacks() {
        InventoryPlayer inventoryplayer = this.player.field_71071_by;
        if (this.recipe instanceof INpcRecipe) {
            int stackLimit = inventoryplayer.func_70297_j_();
            for (int i = 0; i < this.invCrafting.func_70302_i_(); ++i) {
                ItemStack craftStack = this.invCrafting.func_70301_a(i);
                if (craftStack.func_190926_b()) continue;
                ItemStack playerStack = inventoryplayer.func_70448_g();
                int slotID = -1;
                if (this.npcs$canMergeStacks(playerStack, craftStack, stackLimit)) {
                    slotID = inventoryplayer.field_70461_c;
                }
                if (slotID == -1 && this.npcs$canMergeStacks(playerStack = inventoryplayer.func_70301_a(40), craftStack, stackLimit)) {
                    slotID = inventoryplayer.field_70461_c;
                }
                if (slotID == -1) {
                    for (int s = 0; s < inventoryplayer.field_70462_a.size(); ++s) {
                        playerStack = (ItemStack)inventoryplayer.field_70462_a.get(i);
                        if (!this.npcs$canMergeStacks(playerStack, craftStack, stackLimit)) continue;
                        slotID = s;
                        break;
                    }
                }
                if (slotID == -1) {
                    slotID = inventoryplayer.func_70447_i();
                }
                if (slotID != -1) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.invCrafting.func_70302_i_(); ++i) {
                ItemStack craftStack = this.invCrafting.func_70301_a(i);
                if (craftStack.func_190926_b()) continue;
                int slotID = inventoryplayer.func_70432_d(craftStack);
                if (slotID == -1) {
                    slotID = inventoryplayer.func_70447_i();
                }
                if (slotID != -1) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    private boolean npcs$canMergeStacks(ItemStack stack1, ItemStack stack2, int stackLimit) {
        return !stack1.func_190926_b() && NoppesUtilPlayer.compareItems(stack1, stack2, this.npcs$ignoreDamage, this.npcs$ignoreNBT) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < stackLimit;
    }
}

